import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:razinsoft_rider/core/utils/helpers.dart';

import '../../../core/state/app_state.dart';
import '../../../data/models/rider_details_response/rider_details_response.dart';
import '../../../data/repositories/interfaces/auth_repo_interface.dart';
import '../../../data/services/local_storage_service.dart';

class RiderDetailsNotifier extends StateNotifier<AppState<RiderDetailsResponse>> {
  final IAuthRepo authRepo;
  final Ref ref;
  RiderDetailsNotifier({
    required this.ref,
    required this.authRepo,
  }) : super(const AppState.initial()) {
    getRiderDetails();
  }

  Future<void> getRiderDetails() async {
    state = const AppState.loading();
    final result = await authRepo.riderDetails();
    result.fold(
      (failure) {
        state = AppState.error(failure);
        // print(failure.message);
        showNotification(message: failure.message);
      },
      (data) async{
        // print(data.data!.user!.toJson());
        await LocalStorageService().saveUser(user: data.data!.user!.toJson());
        state = AppState.success(data);
      },
    );
  }
}
